# Copyright (c) 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
import LauncherLib

CliSave.GlobalConfigMode.addCommandSequence( 'Launcher.agentShutdownConfig' )

@CliSave.saver( 'Launcher::AgentShutdownConfig',
      LauncherLib.agentShutdownConfigDirPath )
def saveAgentShutdownConfig( entity, root, requireMounts, options ):
   cmds = root[ 'Launcher.agentShutdownConfig' ]
   if entity.shutdown:
      # pylint: disable-next=consider-using-f-string
      cmds.addCommand( 'agent %s shutdown' % entity.name )
   for sliceId in entity.perInstanceShutdown:
      if entity.perInstanceShutdown[ sliceId ]:
         # pylint: disable-next=consider-using-f-string
         cmds.addCommand( 'agent %s-%s shutdown' % ( entity.name, sliceId ) )
   for supervisor in entity.perCellShutdown:
      if entity.perCellShutdown[ supervisor ]:
         # pylint: disable-next=consider-using-f-string
         cmds.addCommand( 'agent %s shutdown supervisor %s' % ( entity.name,
                                                               supervisor ) )
   for cellInstance in entity.perCellInstanceShutdown:
      if entity.perCellInstanceShutdown[ cellInstance ]:
         # pylint: disable-next=consider-using-f-string
         cmds.addCommand( 'agent %s-%s shutdown supervisor %s' % ( entity.name,
                                               cellInstance.instanceId,
                                               cellInstance.mode ) )
