# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
import CliSave

@CliSave.saver( 'Routing::Hardware::Config', 'routing/hardware/config',
                requireMounts=() )
def saveIpOptionHwForwarding( entity, root, requireMounts, options ):
   saveAll = options.saveAll
   cmds = root[ 'Ira.routing' ]

   cmdStr = "ip hardware forwarding options action forward"
   if entity.ipOptionHwForwarding:
      cmds.addCommand( cmdStr )
   elif saveAll:
      cmds.addCommand( "no " + cmdStr )
