# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliSavePlugin.RoutingBgpCliSave import neighborRrHook

def savePeerClusterId( addrOrPgName, peer, saveAll ):
   # pylint: disable-next=consider-using-f-string
   cmdClusterId = 'neighbor {} route-reflector cluster-id {}'.format(
      addrOrPgName, peer.clusterId )
   if peer.clusterId != peer.clusterIdDefault:
      return cmdClusterId
   elif saveAll and not peer.isPeerGroupPeer:
      return f'no neighbor {addrOrPgName} route-reflector cluster-id'
   return None

neighborRrHook.addExtension( savePeerClusterId )

def savePeerSessionTracker( addrOrPgName, peer, saveAll ):
   # pylint: disable-next=consider-using-f-string
   cmdSessionTracker = 'neighbor {} session tracker {}'.format(
      addrOrPgName, peer.sessionTracker )
   if peer.sessionTracker != peer.sessionTrackerDefault:
      return cmdSessionTracker
   elif saveAll and not peer.isPeerGroupPeer:
      return f'no neighbor {addrOrPgName} session tracker'
   return None

neighborRrHook.addExtension( savePeerSessionTracker )
