# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
from CliSavePlugin.EtbaCliSave import PlatformTfaCliSaveMode

PlatformTfaCliSaveMode.addCommandSequence( 'tpIntfHardwareDefinition' )

@CliSave.saver( 'Aegis::HardwareDefinitionConfig',
                'trafficPolicies/hardware/intf/definition' )
def saveTrafficPolicyInterfaceHardwareDefinition( entity, root, requireMounts,
                                                  options ):
   if not ( entity and entity.currCfg ):
      return
   mode = root[ PlatformTfaCliSaveMode ].getSingletonInstance()
   cmds = mode[ 'tpIntfHardwareDefinition' ]
   cmds.addCommand( 'traffic-policy interface hardware definition %s' %
                    entity.currCfg.url )
