# Copyright (c) 2008, 2009, 2010, 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave

# Sometimes we grep startup-config at startup time to apply certain configuration
# without using the Cli parser, such as root password. Things like banner config
# could disrupt this mechanism or even introduce security holes since it contains
# similar lines. We make sure banner config is low priority. At the same time,
# those configs that need to be parsed at startup time should use
# before=[ 'config.priority' ]
CliSave.GlobalConfigMode.addCommandSequence( 'Banner.config',
                                             after=[ 'config.priority' ] )

@CliSave.saver( 'System::BannerConfig', 'sys/banner/config/cli' )
def saveBanners( bannerConfig, root, requireMounts, options ):
   cmds = root[ 'Banner.config' ]
   for attr, keyword in ( ( 'loginBanner', 'login' ), ( 'motd', 'motd' ) ):
      banner = getattr( bannerConfig, attr, '' )
      if banner:
         cmds.addCommand( 'banner ' + keyword + '\n' + banner + 'EOF' )
      elif options.saveAll:
         cmds.addCommand( 'no banner ' + keyword )
