# Copyright (c) 2010-2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
import FileUrl
import SimpleConfigFile
import SecretCli

def addBootConfig( sysdbRoot, options ):
   url = FileUrl.localBootConfig( None, True )
   bootConfigFilename = url.realFilename_
   config = SimpleConfigFile.SimpleConfigFileDict( bootConfigFilename )
   cmds = []
   try:
      if "SWI" in config:
         # pylint: disable-next=consider-using-f-string
         cmds.append( "! boot system %s" % config[ 'SWI' ] )
      if "CONSOLESPEED" in config:
         # pylint: disable-next=consider-using-f-string
         cmds.append( "! boot console speed %s" % config[ 'CONSOLESPEED' ] )
      if "PASSWORD" in config:
         cmd = "! boot secret "
         hashToken = SecretCli.getHashAlgorithm( config[ 'PASSWORD' ] )
         # If we can't parse the password, add an error value. We don't
         # want to break CliSave, but we also want to say that the value is bad.
         if hashToken:
            cmd += ( f"{hashToken} "
                     f"{CliSave.sanitizedOutput( options, config[ 'PASSWORD' ])}" )
         else:
            cmd += "BAD_PASSWORD"
         cmds.append( cmd )
      if "memtest" in config:
         # pylint: disable-next=consider-using-f-string
         cmds.append( "! boot test memory %s" % config[ 'memtest' ] )
   except OSError:
      pass

   return '\n'.join( cmds )

CliSave.addHeaderHook( addBootConfig, 1 )
