# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave

from CliMode.Cdp import CdpBaseMode

class CdpConfigMode( CdpBaseMode, CliSave.Mode ):
   def __init__( self, param ):
      CdpBaseMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

   def skipIfEmpty( self ):
      return True

CliSave.GlobalConfigMode.addChildMode( CdpConfigMode )
CdpConfigMode.addCommandSequence( 'cdp.config' )

@CliSave.saver( 'Cdp::CdpConfig', 'l2discovery/cdp/config' )
def saveCdpConfig( entity, root, requireMounts, options ):

   saveAll = options.saveAll

   mode = root[ CdpConfigMode ].getSingletonInstance()
   cmds = mode[ 'cdp.config' ]
   # cdp
   #     receive
   if entity.rxEnabled:
      cmds.addCommand( 'receive' )
   elif saveAll:
      cmds.addCommand( 'no receive' )

   # cdp
   #     allow tagged-packets
   if entity.allowTaggedPackets:
      cmds.addCommand( 'allow tagged-packets' )
   # it is a hidden cli, so should not be saved with saveAll
