# Copyright (c) 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
import Url
import CliSchedulerLib
from CliSchedulerLib import showTechJobName, showTechCliCommand, \
                            showTechIntervalDefault, showTechMaxLogFilesDefault

CliSave.GlobalConfigMode.addCommandSequence( 'CliScheduler.config' )

@CliSave.saver( 'System::CliScheduler::Config', 'sys/clischeduler/config' )
def saveCliScheduler( config, root, requireMounts, options ):
   cmds = root[ 'CliScheduler.config' ]
   if showTechJobName not in config.scheduledCli:
      cmds.addCommand( f"no schedule {showTechJobName}" )

   if options.saveAll:
      cmds.addCommand( f"schedule config max-concurrent-jobs {config.jobsInProgress}"
                     )
      cmds.addCommand( f"{''if config.prependHostname else 'no '}"
                       "schedule config prepend-hostname-logfile" )
   else:
      if config.jobsInProgress != config.jobsInProgressDefault:
         cmds.addCommand( "schedule config max-concurrent-jobs "
                          f"{config.jobsInProgress}" )
      if config.prependHostname != config.prependHostnameDefault:
         cmds.addCommand( "no schedule config prepend-hostname-logfile" )

   for jobName in sorted( config.scheduledCli ):
      cliConfig = config.scheduledCli[ jobName ]

      cliCmd = f"schedule {cliConfig.name}"
      if cliConfig.at != CliSchedulerLib.scheduleNow:
         cliCmd += f" at {CliSchedulerLib.extractAtFromDateTime(cliConfig.at)}"
      if cliConfig.interval != CliSchedulerLib.scheduleOnce:
         cliCmd += f" interval {cliConfig.interval}"
      else:
         cliCmd += f" {CliSchedulerLib.scheduleOnceStr}"
      cliCmd += f" timeout {int( cliConfig.timeout / 60 )}"
      cliCmd += f" max-log-files {cliConfig.maxLogFiles}"

      if cliConfig.verbose:
         cliCmd += " logging verbose"

      if cliConfig.logDir and \
         cliConfig.logDir != CliSchedulerLib.logPrefixDefault:
         cliCmd += f" loglocation {Url.filenameToUrl( cliConfig.logDir )}"

      if cliConfig.compressAlgo and \
         cliConfig.compressAlgo != CliSchedulerLib.compressAlgoDefault:
         cliCmd += f" compression {cliConfig.compressAlgo}"
       
      cliCmd += f" command {cliConfig.cliCommand}"

      if options.saveAll:
         cmds.addCommand( cliCmd )
      elif cliConfig.name != showTechJobName:
         # CliSave any non show tech jobs
         cmds.addCommand( cliCmd )
      else:
         # CliSave any non default show tech jobs
         if ( cliConfig.cliCommand != showTechCliCommand or 
              cliConfig.interval != showTechIntervalDefault or 
              cliConfig.timeout != CliSchedulerLib.timeoutDefault * 60 or 
              cliConfig.maxLogFiles != showTechMaxLogFilesDefault or 
              cliConfig.logDir != CliSchedulerLib.logPrefixDefault or
              cliConfig.compressAlgo != CliSchedulerLib.compressAlgoDefault or
              cliConfig.at != CliSchedulerLib.scheduleNow ) :
            cmds.addCommand( cliCmd )
