# Copyright (c) 2007, 2008, 2010, 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave

CliSave.GlobalConfigMode.addCommandSequence( 'Timezone.config' )

@CliSave.saver( 'Time::Zone::Config', 'sys/time/zone/config' )
def saveClockConfig( entity, root, requireMounts, options ):
   if entity.zone != entity.defaultZone or options.saveAll:
      cmds = root[ 'Timezone.config' ]
      # pylint: disable-next=consider-using-f-string
      cmd = "clock timezone %s" % entity.zone
      cmds.addCommand( cmd )
