# Copyright (c) 2010, 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
from CliSavePlugin import Management

class ConsoleConfigMode( Management.MgmtConfigMode ):

   def __init__( self, param ):
      Management.MgmtConfigMode.__init__( self, "console" )

CliSave.GlobalConfigMode.addChildMode( ConsoleConfigMode )
ConsoleConfigMode.addCommandSequence( 'Mgmt.console' )

@CliSave.saver( 'Mgmt::Console::Config', 'mgmt/console/config' )
def saveConsole( consoleConfig, root, requireMounts, options ):
   mode = root[ ConsoleConfigMode ].getSingletonInstance()
   cmds = mode[ 'Mgmt.console' ]
   if ( consoleConfig.idleTimeout.timeout !=
        consoleConfig.idleTimeout.defaultTimeout or options.saveAll ):
      # Only need to save timeout if different from default.
      cmds.addCommand( "idle-timeout %s" % # pylint: disable=consider-using-f-string
                       ( int(consoleConfig.idleTimeout.timeout // 60 ) ) )

   if consoleConfig.longHostname:
      cmds.addCommand( "login prompt hostname fqdn" )
   elif options.saveAll:
      cmds.addCommand( "no login prompt hostname fqdn" )

   if consoleConfig.consoleUserMatchList:
      cmd = consoleConfig.consoleUserMatchList
      cmds.addCommand( f"login user match-list {cmd}" )
   elif options.saveAll:
      cmds.addCommand( "no login user match-list" )
