# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliMode.ContainerTracer import CtMode, CtClusterMode
import CliSave
from CliSave import escapeFormatString
from CliSavePlugin.Controllerdb import ( CvxConfigMode,
                                         controllerConfigPath,
                                         getClusterName as getCvxClusterName )
from CliSavePlugin.Security import mgmtSecurityConfigPath
import Tac
import ReversibleSecretCli

#-------------------------------------------------------------------------------
# ContainerTracer Mode Saver
#-------------------------------------------------------------------------------

class ContainerTracerSaveMode( CtMode, CliSave.Mode ):
   def __init__( self, param ):
      CtMode.__init__( self )
      CliSave.Mode.__init__( self, param )

   def skipIfEmpty( self ):
      return True

class ContainerTracerClusterSaveMode( CtClusterMode, CliSave.Mode ):
   def __init__( self, param ):
      CtClusterMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

CvxConfigMode.addChildMode(
   ContainerTracerSaveMode,
   after=[ 'cvx' ]
)

ContainerTracerSaveMode.addCommandSequence(
   'containertracer.config',
   before=[ ContainerTracerClusterSaveMode ]
)

ContainerTracerSaveMode.addChildMode( ContainerTracerClusterSaveMode )
ContainerTracerClusterSaveMode.addCommandSequence( 'containertracer.cluster' )


@CliSave.saver(
   'ContainerTracer::Config',
   'containertracer/config',
   requireMounts=( controllerConfigPath, mgmtSecurityConfigPath )
)
def saveContainterTracerConfig( entity, root, requireMounts, options ):
   # container-tracer mode
   cvxClusterName = getCvxClusterName( requireMounts[ controllerConfigPath ] )
   if not cvxClusterName:
      return
   cvxMode = root[ CvxConfigMode ].getOrCreateModeInstance(
      CvxConfigMode.modeName( cvxClusterName )
   )

   ctMode = cvxMode[ ContainerTracerSaveMode ].getSingletonInstance()
   cmdSeq = ctMode[ 'containertracer.config' ]
   if entity.enabled or options.saveAll:
      cmdSeq.addCommand( "%sshutdown" % ( "no " if entity.enabled else "" ) )

   # cluster mode
   securityConfig = requireMounts[ mgmtSecurityConfigPath ]
   for cluster in entity.cluster.values():
      mode = ctMode[ ContainerTracerClusterSaveMode ].getOrCreateModeInstance(
         cluster.name
      )

      cmdSeq = mode[ 'containertracer.cluster' ]

      if cluster.url:
         cmdSeq.addCommand( 'url %s' % cluster.url )

      if cluster.authSecret:
         formatStr = f"auth {escapeFormatString( cluster.authType )} {{}}"
         cmd = ReversibleSecretCli.getCliSaveCommand( formatStr,
                                                      securityConfig,
                                                      cluster.authSecret )
         cmdSeq.addCommand( cmd )
      if cluster.apiVersion or options.saveAll:
         cmdSeq.addCommand( 'version %s' % cluster.apiVersion )
