# Copyright (c) 2008, 2009, 2010, 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pylint: disable=consider-using-f-string

import CliSave, Tac

CliSave.GlobalConfigMode.addCommandSequence( 'CoredumpControl.config', 
                                             after=[ 'config.priority' ] )

@CliSave.saver( 'System::CoredumpControlConfig', 'sys/coredump/config' )
def saveCoredumpControl( coredumpConfig, root, requireMounts, options ):
   cmds = root[ 'CoredumpControl.config' ]
   # coredumpConfig.mode can take values auto, compressed or disabled
   if coredumpConfig.mode != coredumpConfig.coredumpDefault or options.saveAll:
      if coredumpConfig.mode == "disabled":
         cmds.addCommand( "no system coredump" )
      else:
         cmds.addCommand( "system coredump %s" % \
                       ( coredumpConfig.mode ) )
