# Copyright (c) 2013 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave, Vlan
from CliSavePlugin import EthIntfCliSave
from CliSavePlugin.IntfCliSave import IntfConfigMode

IntfConfigMode.addCommandSequence( 'DhcpSnooping.intf',
                                   after=[ EthIntfCliSave.EthIntfCmdSeq ] )
CliSave.GlobalConfigMode.addCommandSequence( 'DhcpSnooping.config' )

@CliSave.saver( 'Bridging::DhcpSnooping::Config', 'bridging/dhcpsnooping/config' )
def saveDhcpSnoopingConfig( entity, root, requireMounts, options ):

   cmds = root[ 'DhcpSnooping.config' ]

   if entity.enabled:
      if entity.bridging:
         cmds.addCommand( 'ip dhcp snooping bridging' )
      else:
         cmds.addCommand( 'ip dhcp snooping' )
   elif options.saveAll:
      cmds.addCommand( 'no ip dhcp snooping' )
   
   if entity.informationOption:
      cmds.addCommand( 'ip dhcp snooping information option' )
   elif options.saveAll:
      cmds.addCommand( 'no ip dhcp snooping information option' )

   # In case of saveall, it will be default config otherwise user config
   if entity.circuitIdTypeValid != entity.circuitIdTypeValidDefault or \
      entity.circuitIdType != entity.circuitIdTypeDefault or \
      entity.circuitIdFormatString != entity.circuitIdFormatStringDefault or \
      options.saveAll:
      cmds.addCommand( 'ip dhcp snooping information option circuit-id '
            'type %s format %s' % 
            ( str( entity.circuitIdType ) if entity.circuitIdTypeValid else
               'none', entity.circuitIdFormatString ) )

   if entity.vlan:
      vlanStr = Vlan.vlanSetToCanonicalString( entity.vlan )
      cmds.addCommand( 'ip dhcp snooping vlan %s' % vlanStr )
   
   for intfName in entity.userDefinedCircuitId:
      userDefinedCircuitId = entity.userDefinedCircuitId.get( intfName )
      saveDhcpSnoopingIntfConfig( userDefinedCircuitId, root, options )
   

def saveDhcpSnoopingIntfConfig( entity, root, options ):
   mode = root[ IntfConfigMode ].getOrCreateModeInstance( entity.intfName )
   cmds = mode[ 'DhcpSnooping.intf' ]
   cmds.addCommand( 'ip dhcp snooping interface information option circuit-id '
         'type %s value %s' %
         ( str( entity.circuitIdType ) if entity.circuitIdTypeValid else
            'none', entity.circuitIdVal ) )

@CliSave.saver( 'Bridging::DhcpSnooping::Dhcp6Config',
                'bridging/dhcpsnooping/dhcp6Config' )
def saveDhcpV6SnoopingConfig( entity, root, requireMounts, options ):

   cmds = root[ 'DhcpSnooping.config' ]

   if entity.enabled:
      cmds.addCommand( 'ipv6 dhcp snooping' )
   elif options.saveAll:
      cmds.addCommand( 'no ipv6 dhcp snooping' )

   if entity.remoteIdOption:
      cmds.addCommand( 'ipv6 dhcp snooping remote-id option' )
   elif options.saveAll:
      cmds.addCommand( 'no ipv6 dhcp snooping remote-id option' )

   if entity.vlan:
      vlanStr = Vlan.vlanSetToCanonicalString( entity.vlan )
      cmds.addCommand( 'ipv6 dhcp snooping vlan %s' % vlanStr )

