# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pylint: disable=consider-using-f-string
import Tac, CliSave, Tracing
from CliMode.DynamicPrefixList import (
      DynamicPrefixListMode,
      DynPfxSessionBgpMode,
)
from CliSave import GlobalConfigMode

__defaultTraceHandle__ = Tracing.Handle( 'DynamicPrefixList')
t5 = Tracing.trace5 # Info

class DynamicPrefixListCliSaveMode( DynamicPrefixListMode, CliSave.Mode ):
   def __init__( self, param ):
      DynamicPrefixListMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

class DynPfxSessionBgpCliSaveMode( DynPfxSessionBgpMode, CliSave.Mode ):
   def __init__( self, param ):
      DynPfxSessionBgpMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

DynamicPrefixListCliSaveMode.addCommandSequence( 'DynamicPrefixList.config' )
GlobalConfigMode.addChildMode( DynamicPrefixListCliSaveMode,
                               after=[ 'Ira.routeFilter' ] )

DynPfxSessionBgpCliSaveMode.addCommandSequence( 'DynPfxSessionBgp.config' )
GlobalConfigMode.addChildMode( DynPfxSessionBgpCliSaveMode,
                               after=[ 'Ira.routeFilter' ] )

def saveDynamicPrefixConfig( dynPfx, cmds ):
   if dynPfx.matchMap:
      cmd = 'match-map %s' % dynPfx.matchMap
      cmds.addCommand( cmd )

   if dynPfx.matchRcf:
      cmd = 'match rcf %s()' % dynPfx.matchRcf
      cmds.addCommand( cmd )

   if dynPfx.ipv4PrefixList:
      cmd = 'prefix-list ipv4 %s' % dynPfx.ipv4PrefixList
      cmds.addCommand( cmd )

   if dynPfx.ipv6PrefixList:
      cmd = 'prefix-list ipv6 %s' % dynPfx.ipv6PrefixList
      cmds.addCommand( cmd )

def saveSessionBgpConfig( dynPfx, cmds ):
   if dynPfx.sessionBgpAddr:
      sessionBgpAddrList = list( dynPfx.sessionBgpAddr.keys() )
      sessionBgpAddrList.sort()
      for addr in sessionBgpAddrList:
         cmd = 'match session %s originate peer-address' % addr
         cmds.addCommand( cmd )

@CliSave.saver( 'Routing::DynamicPrefixList::Config', 'routing/dynPfxList/config' )
def saveDynamicPrefixListConfig( entity, root, requireMounts, options ):
   # pylint: disable-next=use-implicit-booleaness-not-len
   if not len( entity.dynamicPrefixList ) and not len( entity.sessionBgpDplList ):
      return

   for dynPfxName in entity.dynamicPrefixList:
      t5 ( ' Iterate over Dynamic Prefix List %s' % dynPfxName )
      mode = root[ DynamicPrefixListCliSaveMode
                 ].getOrCreateModeInstance( dynPfxName )
      cmds = mode[ 'DynamicPrefixList.config' ]
      dynPfx = entity.dynamicPrefixList.get( dynPfxName )
      if dynPfx:
         saveDynamicPrefixConfig( dynPfx, cmds )

   for sessionName in entity.sessionBgpDplList:
      t5( ' Iterate over Session BGP Dynamic Prefix List %s' % sessionName )
      mode = root[ DynPfxSessionBgpCliSaveMode
                 ].getOrCreateModeInstance( sessionName )
      cmds = mode[ 'DynPfxSessionBgp.config' ]
      dynPfx = entity.sessionBgpDplList.get( sessionName )
      if dynPfx:
         saveSessionBgpConfig( dynPfx, cmds )
