# Copyright (c) 2008, 2009, 2010, 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pylint: disable=consider-using-f-string

import CliSave

defaultAmbientThreshold = 45

CliSave.GlobalConfigMode.addCommandSequence( 'Thermostat.config' )

@CliSave.saver( 'Environment::Thermostat::Config', 'environment/thermostat/config' )
def saveThermostatConfig( entity, root, requireMounts, options ):
   cmds = root[ 'Thermostat.config' ]
   saveAll = options.saveAll
   if entity.cliNumCoolingZones:
      cmds.addCommand( "environment cooling zones %d" % \
           entity.cliNumCoolingZones )

   if entity.actionOnOverheat == 'actionIgnore':
      cmds.addCommand( "environment overheat action ignore" )
   elif entity.actionOnOverheat == 'actionPowercycle':
      recMode = ""
      ambThsOption = ""
      if entity.recoveryModeOnOverheat == 'recoveryModeRestricted':
         recMode = " recovery restricted"
      if entity.ambientThreshold != defaultAmbientThreshold:
         ambThsOption = " ambient-threshold %s celsius" % entity.ambientThreshold
      cmds.addCommand( "environment overheat action power-cycle%s%s" % \
            ( recMode, ambThsOption ) )
   elif saveAll:
      cmds.addCommand( "environment overheat action shutdown" )

   if not entity.shutdownOnInsufficientFans:
      cmds.addCommand( "environment insufficient-fans action ignore" )
   elif saveAll:
      cmds.addCommand( "environment insufficient-fans action shutdown" )
   if entity.mode == 'manual' and entity.fanSpeed:
      cmds.addCommand( "environment fan-speed override %s" % int( entity.fanSpeed ) )
   elif entity.mode == 'automatic' and entity.userMinFanSpeed:
      cmds.addCommand( "environment fan-speed minimum %s" %
                       int( entity.userMinFanSpeed ) )
   elif saveAll:
      cmds.addCommand( "environment fan-speed auto" )
   if entity.ignoreInvalidTemp:
      cmds.addCommand( "environment temperature invalid action ignore" )
   elif saveAll:
      cmds.addCommand( "no environment temperature invalid action ignore" )
   if entity.ignoreInvalidThirdPartyXcvrTemp:
      cmds.addCommand( "environment temperature transceiver third-party "
                       "invalid action ignore" )
   elif saveAll:
      cmds.addCommand( "no environment temperature transceiver third-party "
                       "invalid action ignore" )
   if saveAll or ( entity.pollInterval != entity.defaultPollInterval ):
      if entity.pollInterval.is_integer():
         cmds.addCommand( "environment temperature poll-interval %d seconds" %
                          entity.pollInterval )
      else:
         cmds.addCommand( "environment temperature poll-interval %d milliseconds" %
                          ( 1000 * entity.pollInterval ) )
