# Copyright (c) 2015 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
from CliSavePlugin import Management
import ExtensionMgrLib
import Tac
from CliMode.Package import RepositoryConfigMode

class PackageConfigSaveMode( Management.MgmtConfigMode ):
   def __init__( self, param ):
      Management.MgmtConfigMode.__init__( self, 'package' )

CliSave.GlobalConfigMode.addChildMode( PackageConfigSaveMode )
PackageConfigSaveMode.addCommandSequence( 'Mgmt.package' )

class RepositoryConfigSaveMode( RepositoryConfigMode, CliSave.Mode ):
   def __init__( self, param ):
      RepositoryConfigMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

PackageConfigSaveMode.addChildMode( RepositoryConfigSaveMode,
                                    after=[ 'Mgmt.package' ] )
RepositoryConfigSaveMode.addCommandSequence( 'package.repository' )

@CliSave.saver( 'Extension::Repo', ExtensionMgrLib.repoConfigPath() )
def savePackageConfig( cfg, root, requireMounts, options ):
   mode = root[ PackageConfigSaveMode ].getSingletonInstance()
   cmds = mode[ 'Mgmt.package' ]

   if cfg.enable != cfg.enableDefault:
      cmds.addCommand( "shutdown" )
   elif options.saveAll:
      cmds.addCommand( "no shutdown" )

   for repo in cfg.repo.values():
      rMode = mode[ RepositoryConfigSaveMode ].getOrCreateModeInstance(
         repo.name )[ 'package.repository' ]
      if repo.format != 'formatUnknown' :
         rMode.addCommand( 'type %s' % # pylint: disable=consider-using-f-string
                           ExtensionMgrLib.repoTypeStrMap[ repo.format ] )
      if repo.url:
         # pylint: disable-next=consider-using-f-string
         rMode.addCommand( 'url %s' % repo.url )
      if repo.description:
         # pylint: disable-next=consider-using-f-string
         rMode.addCommand( 'description %s' % repo.description )
