# Copyright (c) 2016 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
from CliSavePlugin import Management
import Tac
from CliMode.ExternalHttpServices import ExternalHttpServicesVrfConfigModeBase
import ExternalServicesConstants

class ExternalHttpServicesConfigMode( Management.MgmtConfigMode ):

   def __init__( self, param ):
      Management.MgmtConfigMode.__init__( self, "api external-services" )

   def skipIfEmpty( self ):
      return True

CliSave.GlobalConfigMode.addChildMode( ExternalHttpServicesConfigMode )
ExternalHttpServicesConfigMode.addCommandSequence( 'Mgmt.api-external-services' )

class ExternalHttpServicesVrfConfigMode( ExternalHttpServicesVrfConfigModeBase,
                                         CliSave.Mode ):

   def __init__( self, param ):
      ExternalHttpServicesVrfConfigModeBase.__init__( self, param )
      CliSave.Mode.__init__( self, param )

ExternalHttpServicesConfigMode.addChildMode( ExternalHttpServicesVrfConfigMode,
                                             after=[ 'Mgmt.api-external-services' ] )
ExternalHttpServicesVrfConfigMode.addCommandSequence(
                                             'Mgmt.api-external-services-vrf' )

@CliSave.saver( 'HttpService::Config', 'mgmt/capi/config' )
def saveConfig( config, root, requireMounts, options ):
   mode = root[ ExternalHttpServicesConfigMode ].getOrCreateModeInstance(
                                                'api external-services' )
   currCmds = mode[ 'Mgmt.api-external-services' ]
   if config.service[ ExternalServicesConstants.SERVICE_NAME ].enabled:
      currCmds.addCommand( "no shutdown" )
   elif options.saveAll:
      currCmds.addCommand( "shutdown" )

   saveVrf( config, mode, root, options )

def saveVrf( config, parentMode, root, options ):
   # Save the VRF configuration in submode external-services
   for ( vrf, vrfConfig ) in config.vrfConfig.items():
      if ExternalServicesConstants.SERVICE_NAME in vrfConfig.vrfService:
         vrfMode = parentMode[ ExternalHttpServicesVrfConfigMode
                             ].getOrCreateModeInstance( ( vrf, config ) )
         vrfCmd = vrfMode[ 'Mgmt.api-external-services-vrf' ]
         if vrfConfig.vrfService[ ExternalServicesConstants.SERVICE_NAME ]:
            vrfCmd.addCommand( "no shutdown" )
         elif options.saveAll:
            vrfCmd.addCommand( "shutdown" )
