#!/usr/bin/env python3
# Copyright (c) 2016 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.
from __future__ import absolute_import, division, print_function
import CliSave

LINK_FAILURE_THRESHOLD_DEFAULT = 80

CliSave.GlobalConfigMode.addCommandSequence( 'Fabric.globalConfig' )

@CliSave.saver( 'Fabric::InsufficientBandwidthConfig',
                'hardware/fabric/cli/config/bandwidth' )
def saveInsufficientBandwidthConfig( entity, root, requireMounts, options ):
   saveAll = options.saveAll
   saveAllDetail = options.saveAllDetail
   cmds = root[ 'Fabric.globalConfig' ]
   if entity.linkFailureActionIgnore or entity.linkFailureAction == 'ignore':
      cmds.addCommand( 'no switch fabric insufficient-bandwidth action' )
   elif ( entity.linkFailureAction == 'linecardShutdown' and
          entity.linkFailureThresholdPercent != LINK_FAILURE_THRESHOLD_DEFAULT ):
      cmds.addCommand( 'switch fabric insufficient-bandwidth action '
                       'linecard-shutdown threshold %d' % 
                       entity.linkFailureThresholdPercent )
   elif ( entity.linkFailureAction == 'log' and
          entity.linkFailureThresholdPercent != LINK_FAILURE_THRESHOLD_DEFAULT ):
      cmds.addCommand( 'switch fabric insufficient-bandwidth action '
                       'log threshold %d percent' % 
                       entity.linkFailureThresholdPercent )
   elif saveAll or saveAllDetail:
      cmds.addCommand( 'default switch fabric insufficient-bandwidth action' )
