# Copyright (c) 2013 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
from CliSavePlugin import Management
import Url
from CliMode.FileSystemMount import MountNfsMode

class MountConfigMode( Management.MgmtConfigMode ):

   def __init__( self, param ):
      Management.MgmtConfigMode.__init__( self, "file-systems" )

CliSave.GlobalConfigMode.addChildMode( MountConfigMode )
MountConfigMode.addCommandSequence( 'Mgmt.fs' )

class NfsConfigMode( MountNfsMode, CliSave.Mode ):

   def __init__( self, param ):
      MountNfsMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

MountConfigMode.addChildMode( NfsConfigMode )
NfsConfigMode.addCommandSequence( 'Mgmt.fs.nfs' )

@CliSave.saver( 'Mgmt::FileSystems::Config', 'mgmt/filesystems/config' )
def saveFilesystem( mountConfig, root, requireMounts, options ):
   if len( mountConfig.nfsConfig ) > 0:
      mode = root[ MountConfigMode ].getSingletonInstance()
      cmds = mode[ 'Mgmt.fs' ]
     
   for localPath in mountConfig.nfsConfig:
      nfsConfig = mountConfig.nfsConfig[ localPath ]
      mode = root[ MountConfigMode ].getSingletonInstance()
      localFs = Url.filenameToUrl( localPath )
      nfsMode = mode[ NfsConfigMode ].getOrCreateModeInstance( localFs )
      cmds = nfsMode[ 'Mgmt.fs.nfs' ]

      if len(nfsConfig.remoteAddr) != 0 and len(nfsConfig.remotePath) != 0:
         cmds.addCommand( 'remote %s %s' %  # pylint: disable=consider-using-f-string
                     ( nfsConfig.remoteAddr, nfsConfig.remotePath ) )

      if nfsConfig.access != nfsConfig.accessDefault or options.saveAll \
                                                   or options.saveAllDetail:
         # pylint: disable-next=consider-using-f-string
         cmds.addCommand( 'access %s' % ( nfsConfig.access ) )

      if nfsConfig.retransmit != nfsConfig.retransmitDefault or options.saveAll \
                                                   or options.saveAllDetail:
         # pylint: disable-next=consider-using-f-string
         cmds.addCommand( 'options retransmit %d' % ( nfsConfig.retransmit ) )

      if nfsConfig.timeout != nfsConfig.timeoutDefault or options.saveAll \
                                                   or options.saveAllDetail:
         # pylint: disable-next=consider-using-f-string
         cmds.addCommand( 'options timeout %d' % ( nfsConfig.timeout ) )

