#!/usr/bin/env python3
# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
from CliMode.Gnsi import MgmtGnsiMode, MgmtGnsiAcctzMode
from CliSavePlugin.Gnmi import MgmtGnmiSaveMode
from Toggles import GnsiToggleLib
from Toggles import OpenConfigToggleLib

class MgmtGnsiSaveMode( MgmtGnsiMode, CliSave.Mode ):
   # this mode can just be derived from Management.MgmtConfigMode
   def __init__( self, param ):
      param = "api-gnsi"
      MgmtGnsiMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

   def skipIfEmpty( self ):
      return True

CliSave.GlobalConfigMode.addChildMode( MgmtGnsiSaveMode, after=[ MgmtGnmiSaveMode ] )
MgmtGnsiSaveMode.addCommandSequence( "Mgmt.gnsi" )

class MgmtGnsiAcctzSaveMode( MgmtGnsiAcctzMode, CliSave.Mode ):
   # this mode can just be derived from Management.MgmtConfigMode
   def __init__( self, param ):
      param = "api-gnsi-acctz"
      MgmtGnsiAcctzMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

MgmtGnsiSaveMode.addChildMode( MgmtGnsiAcctzSaveMode )
MgmtGnsiAcctzSaveMode.addCommandSequence( 'Mgmt.gnsi.acctz' )

@CliSave.saver( "Gnsi::Config", "mgmt/gnsi/config" )
def saveGnsi( gnsiConfig, root, requireMounts, options ):
   parentMode = root[ MgmtGnsiSaveMode ].getSingletonInstance()
   cmds = parentMode[ 'Mgmt.gnsi' ]

   # gnsi configured for specific endpoints
   for transport in sorted( gnsiConfig.endpoints ):
      cmds.addCommand( f"transport gnmi {transport}" )

   if gnsiConfig.service.authz:
      cmds.addCommand( "service authz" )
   elif options.saveAll:
      cmds.addCommand( "no service authz" )

   if gnsiConfig.service.certz:
      cmds.addCommand( "service certz" )
   elif options.saveAll:
      cmds.addCommand( "no service certz" )

   if gnsiConfig.service.credentialz:
      cmds.addCommand( "service credentialz" )
   elif options.saveAll:
      cmds.addCommand( "no service credentialz" )

   if OpenConfigToggleLib.toggleOCGNSIPathzToggleEnabled():
      if gnsiConfig.service.pathz:
         cmds.addCommand( "service pathz" )
      elif options.saveAll:
         cmds.addCommand( "no service pathz" )

   if GnsiToggleLib.toggleOCGNSIAcctzEnabled():
      if gnsiConfig.service.acctz:
         acctzMode = parentMode[ MgmtGnsiAcctzSaveMode ].getSingletonInstance()
         acctzCmds = acctzMode[ 'Mgmt.gnsi.acctz' ]

         if ( gnsiConfig.acctzConfig and ( gnsiConfig.acctzConfig.historyLimit !=
               gnsiConfig.acctzConfig.historyLimitDefault or options.saveAll ) ):
            acctzCmds.addCommand(
                  f"records history limit {gnsiConfig.acctzConfig.historyLimit}" )
      elif options.saveAll:
         cmds.addCommand( "no service acctz" )
