# Copyright (c) 2013 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
from CliMode.HadoopTracer import MonitorHadoopMode
from CliMode.HadoopTracer import MonitorHadoopClusterMode
from CliSavePlugin.IntfCliSave import IntfConfigMode  # pylint: disable-msg=F0401

class HadoopTracerConfigMode( MonitorHadoopMode, CliSave.Mode ):
   def __init__( self, param ):
      MonitorHadoopMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

class ClusterConfigMode( MonitorHadoopClusterMode, CliSave.Mode ):
   def __init__( self, param ):
      MonitorHadoopClusterMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

CliSave.GlobalConfigMode.addChildMode( HadoopTracerConfigMode,
                                       after=[ IntfConfigMode ] )
HadoopTracerConfigMode.addCommandSequence( "HadoopTracer.config" )
HadoopTracerConfigMode.addChildMode( ClusterConfigMode,
                                     after=[ "HadoopTracer.config" ] )
ClusterConfigMode.addCommandSequence( "cluster.config" )

@CliSave.saver( "HadoopTracer::Config", "hadooptracer/config" )
def saveHadoopTracerConfig( config, root, requireMounts, options ):
   cmds = []
   saveAll = options.saveAll or options.saveAllDetail

   if config.enabled:
      cmds.append( "no shutdown" )
   elif saveAll:
      cmds.append( "shutdown" )

   if cmds:
      mode = root[ HadoopTracerConfigMode ].getOrCreateModeInstance( None )
      cmdSeq = mode[ "HadoopTracer.config" ]
      for cmd in cmds:
         cmdSeq.addCommand( cmd )

   for cluster in sorted( config.clusterConfig ):
      clusterConfig = config.clusterConfig.get( cluster )
      if not clusterConfig:
         continue
      cmds = []

      if clusterConfig.description:
         cmds.append( "description " + clusterConfig.description )

      if clusterConfig.mapReduceVersion == "MR1":
         if ( clusterConfig.host or clusterConfig.user or
              clusterConfig.rpcPort != clusterConfig.rpcPortDefault or saveAll ):
            cmd = "jobtracker"
            if clusterConfig.host:
               cmd += " host %s" % clusterConfig.host
            if clusterConfig.rpcPort != clusterConfig.rpcPortDefault or saveAll:
               cmd += " rpc-port %d" % clusterConfig.rpcPort
            if clusterConfig.user:
               cmd += " user %s" % clusterConfig.user
            cmds.append( cmd )
         if clusterConfig.httpPort != clusterConfig.httpPortDefault or saveAll:
            cmds.append( "tasktracker http-port %d" % clusterConfig.httpPort )

      if clusterConfig.mapReduceVersion == "MR2":
         if ( clusterConfig.resourceManagerHost or 
              clusterConfig.resourceManagerPort != \
                 clusterConfig.resourceManagerPortDefault or saveAll ):
            cmd = "resource-manager"
            if clusterConfig.resourceManagerHost:
               cmd += " host %s" % clusterConfig.resourceManagerHost
            if clusterConfig.resourceManagerPort != \
               clusterConfig.resourceManagerPortDefault or saveAll:
               cmd += " port %d" % clusterConfig.resourceManagerPort
            cmds.append ( cmd )
         if ( clusterConfig.jobHistoryHost or
              clusterConfig.jobHistoryPort != \
                 clusterConfig.jobHistoryPortDefault or saveAll ):
            cmd = "job-history-server"
            if clusterConfig.jobHistoryHost:
               cmd += " host %s" % clusterConfig.jobHistoryHost
            if clusterConfig.jobHistoryPort != \
                   clusterConfig.jobHistoryPortDefault or saveAll:
               cmd += " port %d" % clusterConfig.jobHistoryPort  
            cmds.append( cmd )
         
      if clusterConfig.interval != clusterConfig.intervalDefault or saveAll:
         cmds.append( "interval %d" % clusterConfig.interval )

      if clusterConfig.enabled:
         cmds.append( "no shutdown" )
      elif saveAll:
         cmds.append( "shutdown" )

      mode = root[ HadoopTracerConfigMode ].getOrCreateModeInstance( None )
      mode = mode[ ClusterConfigMode ].getOrCreateModeInstance( cluster )
      if cmds:
         cmdSeq = mode[ "cluster.config" ]
         for cmd in cmds:
            cmdSeq.addCommand( cmd )
