# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
from CliMode.HardwareLed import HardwareLedMode

SAVE_NAME = 'NorCalSys.hardwareLed'

class LedSaveMode( HardwareLedMode, CliSave.Mode ):
   def __init__( self, param ):
      HardwareLedMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

   def skipIfEmpty( self ):
      return True

CliSave.GlobalConfigMode.addChildMode( LedSaveMode )
LedSaveMode.addCommandSequence( SAVE_NAME )

def getCommandColor( led ):
   if led.green == True: # pylint: disable=singleton-comparison
      return 'green'
   elif led.red == True: # pylint: disable=singleton-comparison
      return 'red'
   elif led.yellow == True: # pylint: disable=singleton-comparison
      return 'yellow'
   elif led.blue == True: # pylint: disable=singleton-comparison
      return 'blue'
   else:
      return 'off'

@CliSave.saver( 'Tac::Dir', 'led/config',
                requireMounts=( 'hardware/led/configInit', 'hardware/entmib', ) )
def saveLedCliConfig( entity, root, requireMounts, options ):
   mode = root[ LedSaveMode ].getSingletonInstance()
   cmds = mode[ SAVE_NAME ]
   for ledSet in entity:
      if ledSet == 'HardwareLedCliSet' and entity[ ledSet ].led:
         for name, led in entity[ ledSet ].led.items():
            color = getCommandColor( led )
            if name.startswith( 'Fan' ):
               # Fan-tray commands
               # pylint: disable-next=consider-using-f-string
               cmds.addCommand( 'fan-tray {} color {} {}'.format( name,
                     color, 'flashing'
                                                              if led.flashRate == 1
                                                              else '' ) )
            elif name.startswith( 'Power' ):
               # Power commands
               # pylint: disable-next=consider-using-f-string
               cmds.addCommand( 'power {} color {} {}'.format( name,
                     color, 'flashing'
                                                           if led.flashRate == 1
                                                           else '' ) )
            elif name.startswith( 'Ethernet' ):
               # Interface commands
               # pylint: disable-next=consider-using-f-string
               cmds.addCommand( 'interface {} color {} {}'.format( name, color,
                                                               'flashing'
                                                               if led.flashRate == 1
                                                               else '' ) )
            else:
               # Otherwise we can still run the command with chassis
               # pylint: disable-next=consider-using-f-string
               cmds.addCommand( 'chassis {} color {} {}'.format( name,
                     color, 'flashing'
                                                             if led.flashRate == 1
                                                             else '' ) )
         cmds.addCommand( 'exit' )
         return
