#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
from CliMode.DeviceHealth import (
      DeviceHealthMode,
      CategoryMode
)

CliSave.GlobalConfigMode.addCommandSequence( 'Health.cliConfig' )

class HealthConfigMode( DeviceHealthMode, CliSave.Mode ):
   def __init__( self, param ):
      DeviceHealthMode.__init__( self )
      CliSave.Mode.__init__( self, param )

   def skipIfEmpty( self ):
      # Entering mode enables health monitoring so we cannot skip
      return False

CliSave.GlobalConfigMode.addChildMode( HealthConfigMode, after=[] )
HealthConfigMode.addCommandSequence( 'DeviceHealth.config' )

class HealthCategoryMode( CategoryMode, CliSave.Mode ):
   def __init__( self, param ):
      CategoryMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

HealthConfigMode.addChildMode( HealthCategoryMode, after=[] )
HealthCategoryMode.addCommandSequence( 'DeviceHealth.config.category' )

@CliSave.saver( 'Health::CliConfig', 'health/cliConfig' )
def saveMonitorDevicehealth( entity, root, requireMounts, options ):
   cmds = root[ 'Health.cliConfig' ]

   saveAll = options.saveAll
   saveAllDetail = options.saveAllDetail
   if not entity.configExists and ( saveAll or saveAllDetail ):
      cmds.addCommand( 'default monitor device-health' )
      # when HealthMgr is enabled by default add 
      # default save commands for category and metric.
   elif entity.configExists and entity.enabled:
      healthMode = root[ HealthConfigMode ].getSingletonInstance() 
      cmds1 = healthMode[ 'DeviceHealth.config' ]
      for ( catName, category ) in entity.category.items():
         if not category.builtin:
            # add new category
            catMode = healthMode[ HealthCategoryMode ].getOrCreateModeInstance(
                                                                           catName ) 
         elif category.builtin and category.disabled:
            # disable builtin category
            # pylint: disable-next=consider-using-f-string
            cmds1.addCommand( 'no category %s' % catName )
            continue
         for ( metName, metric ) in entity.metric.items():
            if metric.category == catName:
               if not metric.builtin:
                  # add new metric
                  catMode = healthMode[ HealthCategoryMode ].\
                              getOrCreateModeInstance( catName ) 
                  catCmds = catMode[ 'DeviceHealth.config.category' ]
                  # pylint: disable-next=consider-using-f-string
                  catCmds.addCommand( 'metric %s' % metName )
               elif metric.builtin and metric.disabled:
                  # disable builtin metric
                  catMode = healthMode[ HealthCategoryMode ].\
                              getOrCreateModeInstance( catName ) 
                  catCmds = catMode[ 'DeviceHealth.config.category' ]
                  # pylint: disable-next=consider-using-f-string
                  catCmds.addCommand( 'no metric %s' % metName )
   elif entity.configExists and not entity.enabled:
      cmds.addCommand( 'no monitor device-health' )

