# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Arnet
import Tac
import CliSave
from CliSavePlugin.IntfCliSave import IntfConfigMode
from RoutingIntfUtils import allRoutingProtocolIntfNames


VlanIntfId = Tac.Type( "Arnet::VlanIntfId" )
defaultPref = Tac.Value( "HostInject::Constants" ).defaultPref
IntfConfigMode.addCommandSequence( 'HostInject.intf', after=[ 'Ira.ipIntf' ] )
defaultPrefixV4 = '0.0.0.0/0'
defaultPrefixV6 = '::/0'
defaultLengthV4 = 32
defaultLengthV6 = 128

def saveIntfConfig( entity, intfId, root, saveAll=False, ipv4=True ):
   mode = root[ IntfConfigMode ].getOrCreateModeInstance( intfId )
   cmds = mode[ 'HostInject.intf' ]

   ipAf = "ip"
   if not ipv4:
      ipAf = "ipv6"

   if saveAll:
      # pylint: disable-next=consider-using-f-string
      cmds.addCommand( 'no %s attached-host route export' % ipAf )
   else:
      pref = entity.pref
      cKey = entity.configKey
      prefix = cKey.prefix.stringValue
      length = entity.length
      defaultPrefix = defaultPrefixV4 if ipv4 else defaultPrefixV6
      defaultLength = defaultLengthV4 if ipv4 else defaultLengthV6
      
      cmd = '%s attached-host route' % ipAf # pylint: disable=consider-using-f-string
      if prefix != defaultPrefix:
         # pylint: disable-next=consider-using-f-string
         cmd = cmd + ( ' match prefix %s' % prefix )

      cmd = cmd + ' export'
      if pref != defaultPref:
         cmd = cmd + ( ' %d' % pref ) # pylint: disable=consider-using-f-string

      if length != defaultLength:
         # pylint: disable-next=consider-using-f-string
         cmd = cmd + ( ' prefix-length %d' % length )

      cmds.addCommand( cmd )

def saveHostConfig( hConfig, root, requireMounts, options, ipv4=True ):
   saveAll = options.saveAll
   saveAllDetail = options.saveAllDetail

   intfIdConfigured = []
   for configKey in hConfig.config:
      intfId = configKey.intfId
      if intfId not in intfIdConfigured:
         intfIdConfigured.append( intfId ) 
      saveIntfConfig( hConfig.config[ configKey ], intfId, root,
                      ipv4=ipv4 )

   if saveAll or saveAllDetail:
      allIntfs = allRoutingProtocolIntfNames( requireMounts )
      for intfName in allIntfs:
         if intfName in intfIdConfigured:
            continue
         if VlanIntfId.isVlanIntfId( Arnet.IntfId( intfName ) ):
            saveIntfConfig( None, intfName, root,
                            saveAll=True, ipv4=ipv4 )

#------------------------------------------------------------------------------------
# Save config for v4 HostInjectConfig 
#------------------------------------------------------------------------------------
@CliSave.saver( 'HostInject::HostInjectConfig', 'routing/attached-host/config',
                requireMounts = ( 'interface/config/all', 'interface/status/all' ) )
def saveHostInjectConfig( hConfig, root, requireMounts, options ):
   saveHostConfig( hConfig, root, requireMounts, options )

#------------------------------------------------------------------------------------
# Save config for v6 HostInjectConfig
#------------------------------------------------------------------------------------
@CliSave.saver( 'HostInject::HostInjectConfig', 'routing6/attached-host/config',
                requireMounts = ( 'interface/config/all', 'interface/status/all' ) )
def saveHost6InjectConfig( hConfig, root, requireMounts, options ):
   saveHostConfig( hConfig, root, requireMounts, options, ipv4=False )
