# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliMode.IgdUpnp import IgdMode, IgdVrfMode
from CliSavePlugin.UpnpCliSave import UpnpCliSaveMode
from CliSavePlugin import IntfCliSave
import CliSave
import Tac

class IgdCliSaveMode( IgdMode, CliSave.Mode ):
   def __init__( self, param ):
      IgdMode.__init__( self )
      CliSave.Mode.__init__( self, param )

class IgdVrfCliSaveMode( IgdVrfMode, CliSave.Mode ):
   def __init__( self, param ):
      IgdVrfMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

UpnpCliSaveMode.addCommandSequence( 'Upnp.global' )
CliSave.GlobalConfigMode.addChildMode( UpnpCliSaveMode )

IgdCliSaveMode.addCommandSequence( 'Igd.common' )
UpnpCliSaveMode.addChildMode( IgdCliSaveMode, after=[ 'Upnp.global' ] )

IgdVrfCliSaveMode.addCommandSequence( 'Igd.vrfConfig' )
IgdCliSaveMode.addChildMode( IgdVrfCliSaveMode, after=[ 'Igd.common' ] )
IntfCliSave.IntfConfigMode.addCommandSequence( 'Igd.intfConfig' )

@CliSave.saver( 'IgdUpnp::Config', 'upnp/igd/config' )
def saveIgdConfig( igdConfig, root, requireMounts, options ):
   # UPNP global commands
   upnpMode = root[ UpnpCliSaveMode ].getOrCreateModeInstance( param=None )
   # IGD common commands
   igdMode = upnpMode[ IgdCliSaveMode ].getOrCreateModeInstance( param=None )
   igdCmds = igdMode[ 'Igd.common' ]
   if igdConfig.protocolAndPort != Tac.Value( 'IgdUpnp::IgdProtocolAndPort' ):
      igdCmds.addCommand( "server protocol %s port %d" %
            ( igdConfig.protocolAndPort.protocol, igdConfig.protocolAndPort.port ) )

   # IGD Vrf configuration
   for vrfName, vrfCfg in igdConfig.igdVrfConfig.items():
      igdVrfMode = \
            igdMode[ IgdVrfCliSaveMode ].getOrCreateModeInstance( param=vrfName )
      igdVrfCmds = igdVrfMode[ 'Igd.vrfConfig' ]
      if vrfCfg.ipv4State != "enabled":
         igdVrfCmds.addCommand( "disabled" )
      if vrfCfg.natInfo != Tac.Value( "IgdUpnp::IgdVrfNatInfo" ):
         igdVrfCmds.addCommand(
               "nat service-profile {} access-list {} pool {}".format(
                  vrfCfg.natInfo.profile, vrfCfg.natInfo.acl, vrfCfg.natInfo.pool ) )

   # Interface configuration
   for intf in igdConfig.interface:
      intfMode = \
            root[ IntfCliSave.IntfConfigMode ].getOrCreateModeInstance( intf )
      intfCmds = intfMode[ 'Igd.intfConfig' ]
      intfCmds.addCommand( 'ip upnp igd' )
