# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliMode.IgmpVrfMode import RoutingIgmpMode, RoutingIgmpVrfMode
from CliSavePlugin import IntfCliSave
import CliSave

class RouterIgmpBaseConfigMode( RoutingIgmpMode, CliSave.Mode ):
   def __init__( self, param ):
      RoutingIgmpMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

class RouterIgmpVrfConfigMode( RoutingIgmpVrfMode, CliSave.Mode ):
   def __init__( self, param ):
      RoutingIgmpVrfMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

CliSave.GlobalConfigMode.addChildMode( RouterIgmpBaseConfigMode,
                                 after=[ IntfCliSave.IntfConfigMode ] )
RouterIgmpBaseConfigMode.addCommandSequence( 'Igmp.config' )
RouterIgmpBaseConfigMode.addChildMode( RouterIgmpVrfConfigMode )
RouterIgmpVrfConfigMode.addCommandSequence( 'Igmp.vrf.config' )

