# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
from CliSavePlugin.IntfCliSave import InterfaceDefaultsConfigMode
# pylint: disable-next=consider-using-from-import
import CliSavePlugin.EthIntfCliSave as EthIntfCliSave
from CliMode.IntfOctal import (
   InterfaceDefaultsSlotTypeMode,
   InterfaceDefaultsModuleMode
)
from EthIntfLib import slotTypeFormat
import Tac

class InterfaceDefaultsSlotTypeConfigMode( InterfaceDefaultsSlotTypeMode,
                                           CliSave.Mode ):
   def __init__( self, param ):
      InterfaceDefaultsSlotTypeMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

class InterfaceDefaultsModuleConfigMode( InterfaceDefaultsModuleMode,
                                              CliSave.Mode ):
   def __init__( self, param ):
      # param[ 1 ] contains 'Linecard%d', self.slotNum_ is the number
      self.slotNum_ = int( param[ 1 ][ 8 : ] )
      InterfaceDefaultsModuleMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

   def instanceKey( self ):
      return self.slotNum_

InterfaceDefaultsConfigMode.addChildMode( InterfaceDefaultsSlotTypeConfigMode )
# This command sequence must come before module config mode, because it won't
# exit that mode before running the commands, and 'speed' is a command in both
# slot-type and module mode.
InterfaceDefaultsSlotTypeConfigMode.addCommandSequence( 'interfaceDefaultsSlotType',
                                       before=[ InterfaceDefaultsModuleConfigMode ] )
InterfaceDefaultsSlotTypeConfigMode.addChildMode( InterfaceDefaultsModuleConfigMode )
InterfaceDefaultsModuleConfigMode.addCommandSequence( 'interfaceDefaultsModule' )
EthLinkMode = Tac.Type( 'Interface::EthLinkMode' )

@CliSave.saver( 'Interface::EthPhyIntfGlobalDefaultConfigDir',
                'interface/config/eth/phy/globalDefault' )
# If it is worth adding the extra configuration for saveAll, we can
# iterate through all the available speeds that aren't configured on an interface
# and add 'no speed SPEED' to the saved config for those speeds
def saveDefaultL1Configs( entity, root, requireMounts, options ):
   mode = root[ InterfaceDefaultsConfigMode ].getSingletonInstance()
   saveAll = options.saveAll
   # Iterate over the globalL1DefaultConfig directory. For each item,
   # create a new mode instance to save that config.
   for slotType, slotTypeConfig in entity.hwXcvrSlotDefaultConfig.items():
      # slotTypeMode is the mode from which the speed command is executed
      # slotTypeCmd is the command-sequence representing the speed command
      dashCaseSlotType = slotTypeFormat[ 'toDashCase' ][ slotType ]
      slotTypeMode = mode[ InterfaceDefaultsSlotTypeConfigMode
                         ].getOrCreateModeInstance( dashCaseSlotType )
      slotTypeCmds = slotTypeMode[ 'interfaceDefaultsSlotType' ]
      globalLinkMode = slotTypeConfig.globalL1DefaultConfig.linkMode
      if globalLinkMode != EthLinkMode.linkModeUnknown:
         # pylint: disable-next=consider-using-f-string
         slotTypeCmds.addCommand( 'speed %s' %
                                  EthIntfCliSave.linkModeStrings[ globalLinkMode ] )
      elif saveAll:
         slotTypeCmds.addCommand( 'no speed' )
      # For each slot-type, we must iterate over each moduleL1DefaultConfig present
      moduleConfigs = slotTypeConfig.moduleL1DefaultConfig
      for module, moduleConfig in moduleConfigs.items():
         # Create the mode instance & command sequence. Add speed to the command
         # sequence only if the configured default is not linkModeUnknown
         moduleMode = slotTypeMode[ InterfaceDefaultsModuleConfigMode
                                  ].getOrCreateModeInstance( ( dashCaseSlotType,
                                                               module ) )
         moduleCmds = moduleMode[ 'interfaceDefaultsModule' ]
         moduleLinkMode = moduleConfig.linkMode
         if moduleLinkMode != EthLinkMode.linkModeUnknown:
            # pylint: disable-next=consider-using-f-string
            moduleCmds.addCommand( 'speed %s' %
                                   EthIntfCliSave.linkModeStrings[ moduleLinkMode ] )
         elif saveAll:
            moduleCmds.addCommand( 'no speed' )

