# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave, Vlan
from CliSavePlugin.IntfCliSave import IntfConfigMode

IntfConfigMode.addCommandSequence( 'IpSourceGuard.intf' )
CliSave.GlobalConfigMode.addCommandSequence( 'IpSourceGuard.config' )

@CliSave.saver( 'Ipsg::Config', 'security/ipsg/config' )
def saveIpsgConfig( entity, root, requireMounts, options ):
   intfConfigs = entity.ipsgEnabledIntf
   for intfId, intfConfig in intfConfigs.items():
      saveIpsgIntf( intfConfig, intfId, root, options )

   cmds = root[ 'IpSourceGuard.config' ]
   if entity.ipsgDisabledVlan:
      vlanSet = Vlan.vlanSetToCanonicalString( entity.ipsgDisabledVlan )
      # pylint: disable-next=consider-using-f-string
      cmds.addCommand( 'no ip verify source vlan %s' % vlanSet )
     
def saveIpsgIntf( entity, intfId, root, options ):
   mode = root[ IntfConfigMode ].getOrCreateModeInstance( intfId )
   cmds = mode[ 'IpSourceGuard.intf' ] 
   if entity:
      cmds.addCommand( 'ip verify source' )

