# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
import Tac

tdpState = Tac.Type( "Kabini::TdpState::TdpState" )
CliSave.GlobalConfigMode.addCommandSequence( 'Kabini.config' )

@CliSave.saver( 'Kabini::CliConfig', 'kabini/cliConfig' )
def saveKabiniCliConfig( entity, root, sysdbRoot, options ):
   cmds = root[ 'Kabini.config' ]
   if entity.tdpConfig == tdpState.min:
      cmds.addCommand( 'environment power cpu tdp lowest' )
