#!/usr/bin/env python3
# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
from CliSavePlugin.MrouteCliSave import ( RouterMulticastBaseConfigMode,
                                          RouterMulticastVrfConfigMode,
                                          RouterMulticastAfConfigMode,
                                          getCmdRoot,
                                          getCliSaveVersion )
from McastCommonCliLib import ( AddressFamily,
                                mcastRoutingSupported )
import Tac

CliSave.GlobalConfigMode.addCommandSequence( 'Ip.KernelMfib',
                                             after=[ 'Ip.Multicast' ] )
RouterMulticastBaseConfigMode.addCommandSequence( 'KernelMfib.config',
                                                  after=[ 'Multicast.config' ] )
RouterMulticastVrfConfigMode.addCommandSequence( 'KernelMfib.vrf.config',
                                                 after=[ 'Multicast.vrf.config' ] )

RouterMulticastAfConfigMode.addCommandSequence( 'KernelMfib.vrf.af.config',
                                                after=[ 'Multicast.vrf.af.config' ] )

LegacyConfig = Tac.Type( "McastCommon::LegacyConfig" )

vrfCliSavers = []


def vrfCliSaver( func ):
   vrfCliSavers.append( func )


def saveVrfConfig( vrfConfig, cmds, saveAll, version ):
   for saver in vrfCliSavers:
      saver( vrfConfig, cmds, saveAll, version )


@vrfCliSaver
def saveUnresolvedCacheEntries( vrfConfig, cmds, saveAll, version ):
   if version < LegacyConfig.ipMode:
      cmd = "ip mfib cache-entries unresolved max %d"
   else:
      cmd = "unresolved cache-entries max %d"

   default = vrfConfig.maxUnresolvedCacheEntriesDefault
   if vrfConfig.maxUnresolvedCacheEntries != default or saveAll:
      cmds.addCommand( cmd % vrfConfig.maxUnresolvedCacheEntries )


@vrfCliSaver
def saveUnresolvedPktBuffers( vrfConfig, cmds, saveAll, version ):
   if version < LegacyConfig.ipMode:
      cmd = "ip mfib packet-buffers unresolved max %d"
   else:
      cmd = "unresolved packet-buffers max %d"

   default = vrfConfig.maxUnresolvedPktBuffersDefault

   if vrfConfig.maxUnresolvedPktBuffers != default or saveAll:
      cmds.addCommand( cmd % vrfConfig.maxUnresolvedPktBuffers )


@CliSave.saver( 'Routing::KernelMfib::ConfigColl',
                'routing/kernelmfib/config',
                requireMounts=( 'routing/multicast/legacyconfig',
                                'routing/hardware/status' ) )
def saveMulticastConfig( entity, root, requireMounts, options ):
   saveAll = options.saveAll
   hardwareStatus = requireMounts[ 'routing/hardware/status' ]
   if not mcastRoutingSupported( None, hardwareStatus ):
      saveAll = False

   multicastLegacyConfig = requireMounts[ 'routing/multicast/legacyconfig' ]
   saveVersion = getCliSaveVersion( version=multicastLegacyConfig.version,
                                    saveAll=saveAll )

   for vrfConfig in entity.vrfConfig.values():
      if not vrfConfig.isDefault() or saveAll:
         cmds = getCmdRoot( root, vrfConfig.vrfName, AddressFamily.ipv4,
                            saveVersion, prefix="KernelMfib" )
         saveVrfConfig( vrfConfig, cmds, saveAll, saveVersion )
