# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pylint: disable=singleton-comparison

import Tac
import CliSave
from CliMode.RouterL2Vpn import RoutingL2VpnMode

class RouterL2VpnBaseConfigMode( RoutingL2VpnMode, CliSave.Mode ):
   def __init__( self, param ):
      RoutingL2VpnMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

   def skipIfEmpty( self ):
      return True

CliSave.GlobalConfigMode.addChildMode( RouterL2VpnBaseConfigMode )
RouterL2VpnBaseConfigMode.addCommandSequence( 'l2vpn.config' )

@CliSave.saver( 'Routing::L2Vpn::Config', 'routing/l2vpn/config' )
def saveL2VpnConfig( entity, root, requireMounts, options ):
   mode = root[ RouterL2VpnBaseConfigMode ].getSingletonInstance()
   cmds = mode[ 'l2vpn.config' ]
   if entity.arpL2LearningEnabled:
      cmds.addCommand( 'arp learning bridged' )
   elif options.saveAll:
      cmds.addCommand( 'no arp learning bridged' )

   if entity.arpProxyPrefixList:
      # pylint: disable-next=consider-using-f-string
      cmds.addCommand( 'arp proxy prefix-list %s' % entity.arpProxyPrefixList )
   elif options.saveAll:
      cmds.addCommand( 'no arp proxy prefix-list' )

   if entity.arpSelectiveInstall:
      cmds.addCommand( 'arp selective-install' )
   elif options.saveAll:
      cmds.addCommand( 'no arp selective-install' )

   if entity.ndL2LearningEnabled:
      cmds.addCommand( 'nd learning bridged' )
   elif options.saveAll:
      cmds.addCommand( 'no nd learning bridged' )

   if entity.ndProxyPrefixList:
      # pylint: disable-next=consider-using-f-string
      cmds.addCommand( "nd proxy prefix-list %s" % entity.ndProxyPrefixList )
   elif options.saveAll:
      cmds.addCommand( "no nd proxy prefix-list" )

   if entity.rsFloodingDisabled:
      cmds.addCommand( 'nd rs flooding disabled' )
   elif options.saveAll:
      cmds.addCommand( 'no nd rs flooding disabled' )

   if entity.dadFloodingDisabled:
      cmds.addCommand( 'nd dad flooding disabled' )
   elif options.saveAll:
      cmds.addCommand( 'no nd dad flooding disabled' )

   if entity.virtualRouterNaFloodingDisabled:
      cmds.addCommand( 'virtual-router neighbor advertisement flooding disabled' )
   elif options.saveAll:
      cmds.addCommand( 'no virtual-router neighbor advertisement flooding disabled' )

   if entity.virtualRouterGarpFloodingDisabled:
      cmds.addCommand( 'virtual-router arp advertisement flooding disabled' )
   elif options.saveAll:
      cmds.addCommand( 'no virtual-router arp advertisement flooding disabled' )

   if entity.floodTrafficConfig.enabled:
      cmds.addCommand( 'flooding default disabled' )
   elif options.saveAll:
      cmds.addCommand( 'no flooding default disabled' )

   if entity.floodTrafficConfig.arp:
      cmds.addCommand( 'arp flooding' )
   elif options.saveAll:
      cmds.addCommand( 'no arp flooding' )

   if entity.floodTrafficConfig.nd:
      cmds.addCommand( 'nd flooding' )
   elif options.saveAll:
      cmds.addCommand( 'no nd flooding' )
