# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import CliSave
from CliSavePlugin.IntfCliSave import (
      IntfConfigMode,
)

CliSave.GlobalConfigMode.addCommandSequence( 'LagLib.global',
                                             before=[ IntfConfigMode ] )

@CliSave.saver( 'Lag::Hardware::DlbConfig', 'lag/hardware/dlb/config',
                requireMounts=( 'bridging/hwcapabilities', ) )
def saveDlbLagConfig( entity, root, requireMounts, options ):
   hwCaps = requireMounts[ 'bridging/hwcapabilities' ]
   if not hwCaps.lagDlbSupported:
      return

   cmds = root[ 'LagLib.global' ]
   if entity.globalDlbLagEnable:
      cmds.addCommand( 'port-channel load-balance distribution dynamic' )
   elif options.saveAll or options.saveAllDetail:
      cmds.addCommand( 'no port-channel load-balance distribution' )
