# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
from CliSavePlugin.IntfCliSave import IntfConfigMode
from CliSavePlugin import IntfCliSave

IntfConfigMode.addCommandSequence(
   'LoopbackIntf.config', after=[ 'Arnet.intf' ] )

@CliSave.saver( 'Interface::LoopbackIntfConfig', 'interface/config/loopback/intf',
                attrName='intfConfig', requireMounts=( 'interface/status/all', ) )
def saveLoopbackIntfConfig( entity, root, requireMounts, options ):
   # Save the baseclass (Interface::IntfConfig) attributes.
   IntfCliSave.saveIntfConfig( entity, root, requireMounts, options )

   cliMode = root[ IntfConfigMode ].getOrCreateModeInstance( entity.intfId )
   cmds = cliMode[ 'LoopbackIntf.config' ]

   if entity.hwFwdIdEnabled:
      cmds.addCommand( 'hardware forwarding id' )
   elif options.saveAll:
      cmds.addCommand( 'no hardware forwarding id' )
