# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

#-----------------------------------------------------------------
# This module implements saving the CLI for Maintenance Config
#-----------------------------------------------------------------
import CliSave
from CliMode.MaintenanceModeCliSaveLib import MaintenanceConfigMode


CliSave.GlobalConfigMode.addChildMode( MaintenanceConfigMode )
CliSave.GlobalConfigMode.addCommandSequence( 'Maintenance' )

@CliSave.saver( 'Tac::Dir', 'maintenance/runnability/config' )
def saveMaintenanceConfig( entity, root, requireMounts, options ):
   if "enabled" in entity:
      root[ MaintenanceConfigMode ].getSingletonInstance()

