# Copyright (c) 2010, 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
from CliMode.Mgmt import ManagementMode

class MgmtConfigMode( ManagementMode, CliSave.Mode ):

   def __init__( self, param ):
      ManagementMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

   # makes sure all management configurations are together
   @classmethod
   def modeSortKey( cls ):
      return 'mgmt-' + cls.__name__

   def skipIfEmpty( self ):
      # All mgmt modes are singletons and should not be printed
      # unless there are configs/comments underneath
      return True
