# Copyright (c) 2016 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pylint: disable=consider-using-f-string

import CliSave
from CliSavePlugin import IntfCliSave
import Tac
import Cell 
from Ark import getPlatform
from TypeFuture import TacLazyType

RedundancyMonitorNeighborInterval = TacLazyType( 
   'Interface::RedundancyMonitorNeighborInterval' )
RedundancyMonitorNeighborTimeoutMult = TacLazyType( 
   'Interface::RedundancyMonitorNeighborTimeoutMult' )
RedundancyFallbackDelay = TacLazyType( 'Interface::RedundancyFallbackDelay' )

IntfCliSave.IntfConfigMode.addCommandSequence( 'Mgmtactive.config' )
@CliSave.saver( 'Interface::MgmtActiveIntfConfigDir',
                'interface/config/eth/managementactive',
                requireMounts = ( 'interface/status/all', ) )
def saveMa0IntfConfig( entity, root, requireMounts, options ):
   if entity.intfConfig:
      IntfCliSave.saveIntfConfig( entity.intfConfig, root, requireMounts, options )

      mode = root[ IntfCliSave.IntfConfigMode ].getOrCreateModeInstance(
                   entity.intfConfig.intfId )
      cmds = mode[ 'Mgmtactive.config' ]
      if getPlatform() == 'veos':
         if entity.intfConfig.addr != Tac.Type( "Arnet::EthAddr" ).ethAddrZero:
            cmds.addCommand( 'mac-address %s' % entity.intfConfig.addr )
         elif options.saveAll:
            cmds.addCommand( 'no mac-address' )

      elif Cell.cellType() == "supervisor": 
         # Runs on modular DUT
         intfConfig = entity.intfConfig
         if intfConfig.backupLinkStandby:
            if intfConfig.backupLinkFallbackDelay == (
                  Tac.endOfTime ):
               cmds.addCommand( 'backup-link standby fallback-delay infinity' )
            elif ( options.saveAll or intfConfig.backupLinkFallbackDelay !=
                 intfConfig.defaultFallbackDelay ):
               cmds.addCommand( 'backup-link standby fallback-delay %u'
                  % intfConfig.backupLinkFallbackDelay )
            else:
               cmds.addCommand( 'backup-link standby' )
         elif options.saveAll:
            cmds.addCommand( 'no backup-link standby' )
         
         if intfConfig.redundancyMonitorLinkState:
            cmds.addCommand( 'redundancy monitor link-state' )
         elif options.saveAll:
            cmds.addCommand( 'no redundancy monitor link-state' )
         
         if intfConfig.redundancyMonitorNeighbor:
            neighbor = intfConfig.redundancyMonitorNeighbor
            intervalStr = ''
            multStr = ''
            if ( options.saveAll or 
                 neighbor.intervalMs != 
                 RedundancyMonitorNeighborInterval.defaultVal ):
               intervalStr = " interval %d milliseconds" % neighbor.intervalMs
            if ( options.saveAll or 
                 neighbor.timeoutMult != 
                 RedundancyMonitorNeighborTimeoutMult.defaultVal ):
               multStr = " multiplier %d" % neighbor.timeoutMult
            cmds.addCommand( 'redundancy monitor neighbor ipv6 %s%s%s' % (
               neighbor.addr.stringValue, intervalStr, multStr ) )
         elif options.saveAll:
            cmds.addCommand( 'no redundancy monitor neighbor' )
            
         if ( options.saveAll or 
              intfConfig.redundancyFallbackDelay != 
              RedundancyFallbackDelay.defaultVal ):
            if intfConfig.redundancyFallbackDelay == Tac.endOfTime:
               delayStr = 'infinity'
            else:
               delayStr = '%d seconds' %  intfConfig.redundancyFallbackDelay
            cmds.addCommand( 'redundancy fallback-delay %s' % delayStr )
             
         for slotId, supe in intfConfig.redundancyIntfSet.items():
            intfs = [ intf for intf in supe.intf.values() if intf ]
            if len( intfs ) > 1:
               cmds.addCommand( 'redundancy supervisor %d interface '
                                'primary %s backup %s' % (
                                 slotId, intfs[ 0 ],
                                 ' '.join( intfs[ 1: ] ) ) )
