# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
from CliSavePlugin import Management

class CliManagementConfigMode( Management.MgmtConfigMode ):

   def __init__( self, param ):
      Management.MgmtConfigMode.__init__( self, 'cli' )

CliSave.GlobalConfigMode.addChildMode( CliManagementConfigMode,
                                       after=[ 'Cli.config' ] )
CliManagementConfigMode.addCommandSequence( 'Mgmt.cli' )

@CliSave.saver( 'Cli::Config', 'cli/config' )
def saveConfig( entity, root, requireMounts, options ):
   if entity.deprecatedCmdsSyslogMsg:
      mode = root[ CliManagementConfigMode ].getSingletonInstance()
      cmds = mode[ 'Mgmt.cli' ]
      cmds.addCommand( 'command deprecated log' )
   elif options.saveAll:
      mode = root[ CliManagementConfigMode ].getSingletonInstance()
      cmds = mode[ 'Mgmt.cli' ]
      cmds.addCommand( 'no command deprecated log' )
