#!/usr/bin/env python3
# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave

CliSave.GlobalConfigMode.addCommandSequence( 'Margin.config' )


@CliSave.saver( 'Hardware::Margin::Config', 'hardware/margin/config' )
def saveMarginConfig( entity, root, requireMounts, options ):
   cmds = root[ 'Margin.config' ]

   for rail in entity.marginConfig.values():
      railKey = rail.railKey

      if rail.marginPercent < 0:
         direction = "low"
      elif rail.marginPercent > 0:
         direction = "high"
      else:
         if options.saveAll:
            cmds.addCommand( f'hardware margin {railKey.fru} '
                             f'{railKey.marginSource.lower()} '
                             f'{railKey.marginSourceId} {railKey.railId} nominal' )
         continue

      cmds.addCommand( f'hardware margin {railKey.fru} '
                       f'{railKey.marginSource.lower()} {railKey.marginSourceId} '
                       f'{railKey.railId} {direction} {abs(rail.marginPercent)}' )
