# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
from CliMode.Mcs import McsServiceMode
from CliSavePlugin.Controllerdb import CvxConfigMode
from CliSavePlugin.Controllerdb import controllerConfigPath
from CliSavePlugin.Controllerdb import getClusterName
from CliSavePlugin.Security import mgmtSecurityConfigPath
import ReversibleSecretCli

class McsServiceConfigSaveMode( McsServiceMode, CliSave.Mode ):
   def __init__( self, param ):
      McsServiceMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

   def skipIfEmpty( self ):
      return True

CvxConfigMode.addChildMode( McsServiceConfigSaveMode, after=[ 'cvx' ] )
McsServiceConfigSaveMode.addCommandSequence( "McsService.config" )
CliSave.GlobalConfigMode.addCommandSequence( "McsServiceGlobal.config" )

@CliSave.saver( "Mcs::CliConfig", "mcs/config/cli",
                requireMounts=( controllerConfigPath, mgmtSecurityConfigPath ) )
def saveMcsServiceConfig( entity, root, requireMounts, options ):
   cvxClusterName = getClusterName( requireMounts[ controllerConfigPath ] )
   if not cvxClusterName:
      return

   mode = root[ CvxConfigMode ].getOrCreateModeInstance(
      CvxConfigMode.modeName( cvxClusterName ) )
   mcsServiceMode = mode[ McsServiceConfigSaveMode ].getSingletonInstance()
   cmds = mcsServiceMode[ "McsService.config" ]

   if entity.redisPassword:
      securityConfig = requireMounts[ mgmtSecurityConfigPath ]
      cmd = ReversibleSecretCli.getCliSaveCommand( "redis password {}",
                                                   securityConfig,
                                                   entity.redisPassword )
      cmds.addCommand( cmd )

   if entity.enabled:
      cmds.addCommand( "no shutdown" )
   elif options.saveAll:
      cmds.addCommand( "shutdown" )
