# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
import Toggles.MlagToggleLib

CliSave.GlobalConfigMode.addCommandSequence( 'MlagVrrp.global' )

if Toggles.MlagToggleLib.toggleMlagL2SubinterfacesEnabled():
   path = 'mlag/input/config/cli'
else:
   path = 'mlag/config'

@CliSave.saver( 'Mlag::Config', path,
                requireMounts=( 'mlag/hardware/status', ) )

def saveMlagVrrp( cfg, root, requireMounts, options ):
   saveAll = options.saveAll
   # pylint: disable-msg=W0612
   saveAllDetail = options.saveAllDetail
   # Display config only if mlag is supported by the hardware
   mlagHardwareStatus = requireMounts[ 'mlag/hardware/status' ]
   if not mlagHardwareStatus.mlagSupported:
      saveAll = False
      saveAllDetail = False
      # pylint: enable-msg=W0612
   toRun = []
   if cfg.peerMacRoutingEnabled:
      toRun.append( "ip virtual-router mac-address mlag-peer" )
   elif saveAll:
      toRun.append( "no ip virtual-router mac-address mlag-peer" )
   if toRun:
      cmds = root[ 'MlagVrrp.global' ]
      for c in toRun:
         cmds.addCommand( c )

