# Copyright (c) 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac, CliSave
import Tracing

__defaultTraceHandle__ = Tracing.Handle( 'ModCliSave' )
t0 = Tracing.trace0

CliSave.GlobalConfigMode.addCommandSequence( 'Module.config' )

def cliChipName( tag ):
   return tag.replace( 'SwitchcardCes', 'Switchcard' )

def _getSlots( requireMounts ):
   entityMibRoot = requireMounts[ "hardware/entmib" ]
   if entityMibRoot.chassis and entityMibRoot.chassis.initStatus == "ok":
      return list( entityMibRoot.root.cardSlot.values() )
   return []


def slotName( slot ):
   return f'{cliChipName( slot.tag )}{slot.label}'

@CliSave.saver( 'Power::SoftwareFuse', 'power/fuse/config/admin',
                requireMounts=( 'hardware/entmib', ) )
def saveModuleCli( entity, root, requireMounts, options ):
   cmds = root[ 'Module.config' ]
   poweredOff = list( entity.powerOffRequested )
   slots = _getSlots( requireMounts )
   if options.saveAll:
      # Include all slots unconditionally
      slotList = sorted( slotName( slot ) for slot in slots )
   else:
      # Only include poweredOff slots
      if slots:
         # Filter by valid slots from entmib if available
         slotList = sorted( slotName( slot ) for slot in slots
                            if slotName( slot ) in poweredOff )
      else:
         # The chassis fdl hasn't been executed for some reason
         # (command is run early after boot or there is a Fru/fdl bug)
         slotList = sorted( poweredOff )

   for slot in slotList:
      t0( "iterating over slot", slot )
      if slot in poweredOff:
         cmds.addCommand( f"no power enable module {cliChipName( slot )}" )
      else:
         cmds.addCommand( f"power enable module {slot}" )
