#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave

CliSave.GlobalConfigMode.addCommandSequence( 'Etba.Multicast' )

@CliSave.saver( 'Routing::Multicast::Etba::Config', 'routing/multicast/etba/config' )
def saveEtbaConfig( entity, root, requireMounts, options ):

   saveAll = options.saveAll

   cmds = root[ 'Etba.Multicast' ]

   if entity.forwardingStyle == 'forwardingStyleMfib':
      cmds.addCommand( "platform etba multicast-routing mfib" )
   elif entity.forwardingStyle == 'forwardingStyleBess':
      cmds.addCommand( "platform etba multicast-routing bess" )
   elif saveAll:
      cmds.addCommand( "platform etba multicast-routing kernel" )
