# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
from CliMode.MssClient import MgmtCvxMssMode
from CliSavePlugin.ControllerClient import ( MgmtCvxConfigMode,
                                             mgmtControllerConfigPath )

#------------------------------------------------------------------------------
# Mss Mode Saver
#------------------------------------------------------------------------------
class MgmtCvxMssConfigSaveMode( MgmtCvxMssMode, CliSave.Mode ):
   def __init__( self, param ):
      MgmtCvxMssMode.__init__( self )
      CliSave.Mode.__init__( self, param )

MgmtCvxConfigMode.addChildMode( MgmtCvxMssConfigSaveMode, after=[ 'Mgmt.cvx' ] )
MgmtCvxMssConfigSaveMode.addCommandSequence( 'mssclient.config' )

#------------------------------------------------------------------------------
# Entity Saver
#------------------------------------------------------------------------------
@CliSave.saver( 'MssClient::Config',
                'mssclient/config',
                requireMounts=( mgmtControllerConfigPath, ) )
def saveMgmtCvxMssConfig( entity, root, requireMounts, options ):
   cmds = []
   if not entity.enabled:
      cmds.append( "disabled" )
   elif options.saveAll:
      cmds.append( "no disabled" )

   if cmds:
      clusterName = requireMounts[ mgmtControllerConfigPath ].clusterName
      mgmtCvxMode = root[ MgmtCvxConfigMode ].getOrCreateModeInstance(
         MgmtCvxConfigMode.modeName( clusterName ) )
      mssMode = mgmtCvxMode[ MgmtCvxMssConfigSaveMode ].getOrCreateModeInstance(
               'mgmt-cvx-mss' )
      cmdSeq = mssMode[ 'mssclient.config' ]
      for cmd in cmds:
         cmdSeq.addCommand( cmd )
