# Copyright (c) 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
import CliSave
import EthIntfUtil
from CliSavePlugin.IntfCliSave import IntfConfigMode

IntfConfigMode.addCommandSequence( 'Mvrp.config' )

@CliSave.saver( 'Mvrp::Config', 'mvrp/input/config/cli',
                requireMounts=( 'interface/config/eth/phy/slice', ) )
def saveConfig( entity, root, requireMounts, options ):
   saveAll = options.saveAll

   if saveAll:
      phyIntfConfigDir = requireMounts[ 'interface/config/eth/phy/slice' ]
      phyIntfNames = EthIntfUtil.allPhyEthernetInterfaceNames( phyIntfConfigDir )
      cfgIntfNames = set( entity.intfEnable )
      cfgIntfNames.update( phyIntfNames )
   else:
      cfgIntfNames = entity.intfEnable

   for intfName in cfgIntfNames:
      intfMode = root[ IntfConfigMode ].getOrCreateModeInstance(
         intfName )
      cmds = intfMode[ 'Mvrp.config' ]

      intfEnable = entity.intfEnable.get( intfName )
      if intfEnable:
         cmds.addCommand( 'mvrp ' )
      elif saveAll:
         cmds.addCommand( 'no mvrp' )
