# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
from TypeFuture import TacLazyType
import CliSave

EthAddr = TacLazyType( "Arnet::EthAddr" )
IntfId = TacLazyType( "Arnet::IntfId" )

configName = 'NbrClassification.config'
CliSave.GlobalConfigMode.addCommandSequence( configName )

@CliSave.saver( 'Identity::NbrClassification::CliConfig',
                'identity/nbrClassification/cliConfig' )
def saveNbrClassificationCliConfig( entity, root, requireMounts, options ):
   # Save the global configuration.
   cmds = root[ configName ]

   nbrClassCli = 'neighbor classification mac address %s'
   for _, neighbor in sorted( entity.neighbor.items() ):
      addr = EthAddr()
      addr.stringValue = neighbor.ethAddr
      cli = nbrClassCli % addr.displayString
      if not neighbor.classification:
         cli += " none"
      if neighbor.classification.telephone:
         cli += " phone"
      cmds.addCommand( cli )
