# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
from Ethernet import (
   convertMacAddrCanonicalToDisplay,
   )
from CliMode.NeighborResolution import (
   NeighborResolutionMode,
   NeighborResolutionIntfMode,
   )


class NeighborResolutionConfigMode( NeighborResolutionMode, CliSave.Mode ):
   def __init__( self, param ):
      NeighborResolutionMode.__init__( self )
      CliSave.Mode.__init__( self, param )

   def skipIfEmpty( self ):
      return True

CliSave.GlobalConfigMode.addChildMode( NeighborResolutionConfigMode,
                                       after=[ 'Ira.staticNeighbor6' ] )
NeighborResolutionConfigMode.addCommandSequence( 'Arp.neighborResolution' )

class NeighborResolutionIntfConfigMode( NeighborResolutionIntfMode, CliSave.Mode ):
   def __init__( self, intfId ):
      NeighborResolutionIntfMode.__init__( self, intfId )
      CliSave.Mode.__init__( self, param=intfId )

   def skipIfEmpty( self ):
      return True

NeighborResolutionConfigMode.addChildMode( NeighborResolutionIntfConfigMode )
NeighborResolutionIntfConfigMode.addCommandSequence( 'Arp.neighborResolutionIntf' )

class NeighborCmd:
   def __init__( self, neighbor ):
      self.neighbor = neighbor

   def cmd( self ):
      return (
         f'neighbor {self.neighbor.addr} '
         f'mac-address {convertMacAddrCanonicalToDisplay(self.neighbor.mac)}'
      )

@CliSave.saver( 'Arp::Lib::NeighborResolution::Config::SourceRoot',
                'arp/neighborResolution/config/cli' )
def saveNeighborResolutionConfig( entity, root, requireMounts, options ):
   topMode = root[ NeighborResolutionConfigMode ].getOrCreateModeInstance(
         entity.name )
   for intfId, interface in entity.interface.items():
      intfMode = topMode[ NeighborResolutionIntfConfigMode ].getOrCreateModeInstance(
            intfId )
      for addr in sorted( interface.v4Neighbor ):
         neighborCmd = NeighborCmd( interface.v4Neighbor[ addr ] )
         cmds = intfMode[ 'Arp.neighborResolutionIntf' ]
         cmds.addCommand( neighborCmd.cmd() )

      for addr in sorted( interface.v6Neighbor ):
         neighborCmd = NeighborCmd( interface.v6Neighbor[ addr ] )
         cmds = intfMode[ 'Arp.neighborResolutionIntf' ]
         cmds.addCommand( neighborCmd.cmd() )
