# Copyright (c) 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from NetworkUrlCliLib import supportedNetworkUrlProtocols
import CliSave
from CliSavePlugin.IntfCliSave import IntfConfigMode
import Tac

CliSave.GlobalConfigMode.addCommandSequence( 'NetworkUrl.srcIntf',
                                             after=[ IntfConfigMode ] )
@CliSave.saver( 'Mgmt::NetworkUrl::Config', 'mgmt/networkUrl/config' )
def saveNetworkUrlSrcIntfGlobal( networkUrlConfig, root, requireMounts, options ):
   cmdRoot = root[ 'NetworkUrl.srcIntf' ]
   for proto in sorted( supportedNetworkUrlProtocols() ):
      if proto in networkUrlConfig.protocolConfig:
         protConf = networkUrlConfig.protocolConfig[ proto ]
         # iterate through source interfaces
         for srcIntf in protConf.srcIntf.values():
            if srcIntf.usedSourceInterface:
               token = 'source-interface'
            else:
               token = 'local-interface'
            # pylint: disable-next=consider-using-f-string
            template = 'ip %%s client %s %%s%%s' % token
            # pylint: disable-next=consider-using-f-string
            vrfToken = ' vrf %s' % srcIntf.vrf if srcIntf.saveWithVrfArg else ''
            cmdRoot.addCommand( template % ( proto, srcIntf.intfName, vrfToken ) )
      elif options.saveAll:
         if proto == 'http':
            srcIntfCmd = 'local-interface'
         else:
            srcIntfCmd = 'source-interface'
         # pylint: disable-next=consider-using-f-string
         cmdRoot.addCommand( 'no ip %s client %s' % ( proto, srcIntfCmd ) )
