#!/usr/bin/env python3
# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
import CliSave
from IpLibConsts import DEFAULT_VRF
from PerfsonarTwampConsts import defaultLocalAddress, defaultListenPort
from PerfsonarTwampConsts import defaultMaxTestPort, defaultMinTestPort
from PerfsonarTwampConsts import defaultMaxControlSessions, defaultUser
from PerfsonarTwampConsts import defaultGroup, defaultAuthMode

CliSave.GlobalConfigMode.addCommandSequence( 'PerfsonarTwamp.config' )

serverKeyword = 'twserver'

# Recreate "twserver....." command from corresponding Sysdb state
@CliSave.saver( "PerfsonarTwamp::Config", "perfsonartwamp/config" )
def saveTwampConfig( entity, root, requireMounts, options ):
   cmds = root[ "PerfsonarTwamp.config" ]

   if not entity.server:
      if options.saveAll:
         cmds.addCommand( "no %s" % serverKeyword )
      return

   for vrfName, server in sorted( entity.server.items() ):
      serverCmd = serverKeyword
      if vrfName != DEFAULT_VRF:
         serverCmd += " vrf %s" % vrfName

      if server.listenPort != defaultListenPort:
         serverCmd += " listen-port %d" % server.listenPort

      if server.localIpOrHost != defaultLocalAddress:
         serverCmd += " local-address %s" % server.localIpOrHost

      if server.minTestPort != defaultMinTestPort:
         serverCmd += " min-test-port %d" % server.minTestPort

      if server.maxTestPort != defaultMaxTestPort:
         serverCmd += " max-test-port %d" % server.maxTestPort

      if server.maxControlSessions != defaultMaxControlSessions:
         serverCmd += " max-control-sessions %d" % server.maxControlSessions

      if server.user != defaultUser:
         serverCmd += " user %s" % server.user

      if server.group != defaultGroup:
         serverCmd += " group %s" % server.group

      if server.authMode != defaultAuthMode:
         if server.authMode == 'A':
            serverCmd += " auth-mode authenticated"
         elif server.authMode == 'E':
            serverCmd += " auth-mode encrypted"
         elif server.authMode == 'O':
            serverCmd += " auth-mode open"


      cmds.addCommand( serverCmd )
