# Copyright (c) 2015 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.
import CliSave, CliParser
import Tac
import McastCommonCliLib
from CliSavePlugin.PimCliSaveLib import RouterPimBidirBaseConfigMode, \
      RouterPimBidirVrfConfigMode, RouterPimBidirAfConfigMode
from CliSavePlugin.MrouteCliSave import getCliSaveVersion
from CliSavePlugin.PimCliSaveLib import getCmdRootBidir

PimLegacyConfig = Tac.Type( "McastCommon::LegacyConfig" )
AddressFamily = Tac.Type( "Arnet::AddressFamily" )

CliSave.GlobalConfigMode.addCommandSequence( 'Ip.PimBidir' )

RouterPimBidirBaseConfigMode.addCommandSequence( 'PimBidir.config' )
RouterPimBidirBaseConfigMode.addChildMode( RouterPimBidirVrfConfigMode )
RouterPimBidirBaseConfigMode.addChildMode( RouterPimBidirAfConfigMode )
RouterPimBidirVrfConfigMode.addCommandSequence( 'PimBidir.vrf.config' )
RouterPimBidirVrfConfigMode.addChildMode( RouterPimBidirAfConfigMode )
RouterPimBidirAfConfigMode.addCommandSequence( 'PimBidir.vrf.af.config' )

# pylint: disable-msg=E0102
@CliSave.saver( 'Routing::Pim::Bidir::ConfigColl',
                'routing/pim/bidir/config',
                requireMounts = ( 'routing/hardware/status',
                   'routing/pim/bidir/legacyconfig', ) )
def saveConfig( pimBidirConfigRoot, root, requireMounts, options ):
   saveAll = options.saveAll
   # Save the default config only if the platform supports multicast routing
   if not McastCommonCliLib.mcastRoutingSupported(
         None,
         requireMounts[ 'routing/hardware/status' ] ):
      saveAll = False

   routingHwStatus = requireMounts[ 'routing/hardware/status' ]

   legacyConfig = requireMounts[ 'routing/pim/bidir/legacyconfig' ]
   legacyVersion = PimLegacyConfig.ipMode \
               if not CliParser.DEPRECATED_CMD_ALLOWED else legacyConfig.version

   if saveAll and legacyVersion != legacyConfig.ipMode and \
         pimBidirConfigRoot.isDefault:
      legacyVersion = getCliSaveVersion( legacyConfig.version, saveAll )

   if not routingHwStatus.pimBidirectionalSupported:
      return

   for vrfName in pimBidirConfigRoot.vrfConfig:
      pimBidirConfig = pimBidirConfigRoot.vrfConfig.get( vrfName )
      cmds = getCmdRootBidir( root, vrfName, AddressFamily.ipv4, legacyVersion )
      if pimBidirConfig.groupExpiryInterval != \
         pimBidirConfig.groupExpiryIntervalDefault or saveAll:
         if legacyVersion != PimLegacyConfig.ipMode:
            # pylint: disable-next=consider-using-f-string
            cmd = 'ip pim group-expiry-timer %s' % pimBidirConfig.groupExpiryInterval
         else:
            # pylint: disable-next=consider-using-f-string
            cmd = 'group-expiry-timer %s' % pimBidirConfig.groupExpiryInterval
         cmds.addCommand( cmd )
