#!/usr/bin/env python3
# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave

SAVE_NAME = 'NorCalSys.powerSavingLed'

CliSave.GlobalConfigMode.addCommandSequence( SAVE_NAME )

@CliSave.saver( 'Hardware::Led::LedCliConfig', 'hardware/led/cli/config' )
def savePowerSavingLedCliConfig( entity, root, requireMounts, options ):
   cmds = root[ SAVE_NAME ]
   if entity.powerSaving:
      cmds.addCommand( 'environment power save led auto-off' )
   elif options.saveAll:
      cmds.addCommand( 'no environment power save led auto-off' )
